<%@ Page Language="C#" AutoEventWireup="true" Inherits="Voxco.Reporting.DisplayReportGraph" Codebehind="DisplayReportGraph.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Chart Generator</title>
    <meta http-equiv="Page-Enter" content="revealTrans(Duration=0,Transition=20)" />
	<meta http-equiv="Page-Exit" content="revealTrans(Duration=0,Transition=20)" />
    <style media="print" type="text/css">
        .onlyscreen
        {
            display: none;
        }
        .printerandscreen
        {
            display: block;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
		
		<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
			<script type="text/javascript">
				function DownloadReport(url)
				{					
					var _obj = document.getElementById("DownloadReportFrame");        
					_obj.src = url;
					//window["DownloadReportFrame"].location = url;
				}   
		        
				function ExcecuteIECommand( _commandName )
				{
					//With IE 5.5/6 on Win you can try it as follows:
					var _div = document.getElementById("GraphRadChart");
					if( _div )
					{
						_div.contentEditable = "true";
						var _controlRange;
						if ( document.body.createControlRange ) 
						{
							_controlRange = document.body.createControlRange();
							_controlRange.addElement(_div);
							_controlRange.execCommand( _commandName );
						}
						_div.contentEditable = "false";
					}
				}
		        
				function PrintImage()
				{
					//ExcecuteIECommand( "Print" );
					window.print();
				} 
		        
				function CopyToClipBoard()
				{
					ExcecuteIECommand( "Copy" );
				}
			</script>
		</telerik:RadScriptBlock>
		
		<telerik:RadScriptManager ID="RadScriptManger1" runat="server"></telerik:RadScriptManager>
         
        <telerik:RadAjaxManager ID="MainAjaxManager" runat="server" OnAjaxRequest="MainAjaxManager_OnAjaxRequest" EnableAJAX="true">
        </telerik:RadAjaxManager>

        <telerik:RadAjaxPanel ID="VariablesRadAjaxPanel" runat="server" EnableAJAX="False" Width="700px" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="RadAjaxPanel_OnAjaxRequest">
        
            <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" >
                <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
            </telerik:RadAjaxLoadingPanel>
        
            <table border="0" >
                <tr class="onlyscreen">
                    <td valign="top" colspan="2">
                        <asp:Button id="btnRedraw" runat="server" Font-Size="8pt" Visible="false" Text="<%$ Resources:Resource, Refresh%>" OnClick="btnReload_Click" />
                        <input type="button" id="btnPrint" runat="server" value="<%$ Resources:Resource, PrintImage %>" style="Font-Size:8pt" onclick="PrintImage();" />
                        <input type="button" id="btnExportImage" runat="server" value="<%$ Resources:Resource, ExportImage %>" style="Font-Size:8pt" />
                        <input type="button" id="btnCopyImage" runat="server" value="<%$ Resources:Resource, CopyImage %>" style="Font-Size:8pt" onclick="CopyToClipBoard();" />
                    </td>
                </tr>
                <tr class="onlyscreen">
                    <td width="275px">
                        <asp:Panel ID="VariableSelection" runat="server" Font-Size="9pt" Width="275px" GroupingText="<%$ Resources:Resource, VariablesSelection %>" >
                        
                            <table id="CrossTabOptionTable" runat="server">
                                <tr>
                                    <td width="100px" ><asp:Label ID="RowVariableLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, RowVariable%>" ></asp:Label>:</td>
                                    <td><asp:DropDownList ID="RowVariableList" runat="server" Width="150px" Font-Size="8pt" AutoPostBack="true" OnSelectedIndexChanged="btnReload_Click"></asp:DropDownList></td>
                                </tr>
                                <tr>    
                                    <td width="100px"><asp:Label ID="BannerLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, BannerVariable%>"></asp:Label>:</td>
                                    <td><asp:DropDownList ID="BannerList" runat="server" Width="150px" Font-Size="8pt" DataValueField="Key" DataTextField="Value"  AutoPostBack="true" OnSelectedIndexChanged="GraphTypeList_SelectedIndexChanged" ></asp:DropDownList></td> 
                                </tr>
                                <tr>    
                                    <td width="100px"><asp:Label ID="BannerValueLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, BannerValue%>">:</asp:Label>:</td>
                                    <td><asp:DropDownList ID="BannerValueList" runat="server" Width="150px" Font-Size="8pt" DataValueField="Key" DataTextField="Value" Enabled="false" AutoPostBack="true" OnSelectedIndexChanged="btnReload_Click" ></asp:DropDownList></td> 
                                </tr>
                                <tr>    
                                    <td width="100px"><asp:Label ID="BreakdownLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, BreakdownValue%>">:</asp:Label>:</td>
                                    <td><asp:DropDownList ID="BreakdownList" runat="server" Width="150px" Font-Size="8pt" Enabled="false" AutoPostBack="true" OnSelectedIndexChanged="btnReload_Click" ></asp:DropDownList></td> 
                                </tr>
                            </table>
                            
                            <table id="QPrintOptionTable" runat="server" visible="false">
                                <tr>
                                    <td width="100px" ><asp:Label ID="QuestionLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, Question%>" ></asp:Label>:</td>
                                    <td><asp:DropDownList ID="QuestionList" runat="server" Width="150px" Font-Size="8pt" AutoPostBack="true" OnSelectedIndexChanged="btnReload_Click"></asp:DropDownList></td>
                                </tr>
                                <tr><td colspan="2">&nbsp;</td></tr>
                                <tr><td colspan="2">&nbsp;</td></tr>
                                <tr><td colspan="2">&nbsp;</td></tr>
                                <tr><td colspan="2">&nbsp;</td></tr>
                            </table>
                            
                        </asp:Panel>
                     </td>
                     <td width="300px">   
                        <asp:Panel ID="OptionsPanel" runat="server" Font-Size="9pt" Width="300px" GroupingText="<%$ Resources:Resource, Options %>" >
                        
                            <table>
                                <tr>
                                    <td width="100px"><asp:Label ID="GraphSizeLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, GraphSize%>"></asp:Label>:</td>
                                    <td>
                                        <asp:DropDownList ID="GraphSizeList" runat="server" Width="150px" Font-Size="8pt" AutoPostBack="true" OnSelectedIndexChanged="btnReload_Click" >
                                            <asp:ListItem Value="400x380" Text="<%$ Resources:Resource, Small%>"> </asp:ListItem>
                                            <asp:ListItem Selected="True" Value="500x580" Text="<%$ Resources:Resource, Normal%>"> </asp:ListItem>
                                            <asp:ListItem  Value="700x780" Text="<%$ Resources:Resource, Large%>"> </asp:ListItem>
                                            <asp:ListItem  Value="1000x1080" Text="<%$ Resources:Resource, Huge%>"> </asp:ListItem>
                                            <asp:ListItem  Value="" Text="<%$ Resources:Resource, MaxSize%>" Enabled="false" > </asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="100px"><asp:Label ID="GraphTypeLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, GraphType%>"></asp:Label>:</td>
                                    <td>
                                        <asp:DropDownList ID="GraphTypeList" runat="server" Width="150px" Font-Size="8pt" AutoPostBack="true" OnSelectedIndexChanged="GraphTypeList_SelectedIndexChanged">
                                            <asp:ListItem Value="Area" Text="<%$ Resources:Resource, Area%>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Value="Bar" Text="<%$ Resources:Resource, Bar %>"> </asp:ListItem>
                                            <asp:ListItem Value="Bubble" Text="<%$ Resources:Resource, Bubble %>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Selected="True" Value="Column" Text ="<%$ Resources:Resource, Column %>"> </asp:ListItem>
                                            <asp:ListItem Value="Line" Text="<%$ Resources:Resource, Line%>"> </asp:ListItem>
                                            <asp:ListItem Value="Pie" Text="<%$ Resources:Resource, Pie%>"> </asp:ListItem>
                                            <asp:ListItem Value="Point" Text="<%$ Resources:Resource, Point%>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Value="Spline" Text="<%$ Resources:Resource, Spline%>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Value="StackedArea" Text="<%$ Resources:Resource, StackedArea%>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Value="StackedArea100" Text="<%$ Resources:Resource, StackedArea100%>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Value="StackedBar" Text="<%$ Resources:Resource, StackedBar%>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Value="StackedBar100" Text="<%$ Resources:Resource, StackedBar100%>" Enabled="false"> </asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="100px">
                                        <asp:Label ID="SkinLabel" runat="server" Font-Size="9pt" Text="<%$ Resources:Resource, Appearance%>"></asp:Label>:
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="SkinList" runat="server" Width="150px" Font-Size="8pt" AutoPostBack="true" OnSelectedIndexChanged="btnReload_Click" >
                                            <asp:ListItem Selected="TRUE" Value="" Text="Voxco"> </asp:ListItem>
                                            <asp:ListItem Value="Default" Text="<%$ Resources:Resource, Default %>" Enabled="false"> </asp:ListItem>
                                            <asp:ListItem Value="DeepBlue" Text="<%$ Resources:Resource, DeepBlue %>"> </asp:ListItem>
                                            <asp:ListItem Value="DeepGreen" Text="<%$ Resources:Resource, DeepGreen %>"> </asp:ListItem>
                                            <asp:ListItem Value="DeepRed" Text="<%$ Resources:Resource, DeepRed %>"> </asp:ListItem>
                                            <asp:ListItem Value="DeepGray" Text="<%$ Resources:Resource, DeepGray%>"> </asp:ListItem>
                                            <asp:ListItem Value="LightBlue" Text="<%$ Resources:Resource, LightBlue%>"> </asp:ListItem>
                                            <asp:ListItem  Value="LightGreen" Text="<%$ Resources:Resource, LightGreen%>"> </asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:CheckBox ID="DisplayLegendChbx" runat="server" Checked="true" Text="<%$ Resources:Resource, DisplayLegend%>" AutoPostBack="true" OnCheckedChanged="btnReload_Click"  />
                                    </td>
                                    <td>
                                        <asp:CheckBox ID="DisplayPlotValuesChbx" runat="server" Text="<%$ Resources:Resource ,DisplayPlotValues%>" AutoPostBack="true" OnCheckedChanged="btnReload_Click"  />
                                        <asp:CheckBox ID="AutoShrinkChbx" runat="server" Visible="false" Text="<%$ Resources:Resource, AutoShrink%>" AutoPostBack="true" OnCheckedChanged="btnReload_Click"  />
                                    </td>
                                </tr>
                            </table>
                            
                        </asp:Panel>
                    </td>
                    <td width="50%">
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <telerik:RadChart ID="GraphRadChart" runat="server" Width="680px" Height="580px" DefaultType="Bar" EnableViewState="False" >
                        </telerik:RadChart>
                    </td>
                </tr>
            </table>
            
            <iframe class="onlyscreen" id="DownloadReportFrame" width="0" height="0"></iframe>
            
        </telerik:RadAjaxPanel>
        
    </form>
</body>
</html>
